import React from "react";
import { useMediaQuery, useTheme } from "@mui/material";

const SubscribeImage = () => {
  const theme = useTheme();
  const isSmall = useMediaQuery(theme.breakpoints.down("sm"));
  return (
    <svg
      width={isSmall ? "200" : "307"}
      height={isSmall ? "160" : "233"} viewBox="0 0 317 243" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_2950_15049)">
      <path d="M288.29 163.928C287.872 172.105 295.224 176.832 302.245 172.725C304.566 171.369 306.771 169.066 308.509 165.321C315.104 151.053 309.287 140.415 297.74 143.193C290.611 144.911 288.709 155.823 288.298 163.921L288.29 163.928Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M14.1811 95.9077C12.9846 101.321 7.34085 103.089 3.49185 99.1482C2.22326 97.8491 1.19254 95.9438 0.731234 93.1941C-1.02028 82.6933 4.68836 76.7897 11.7305 80.6797C16.0768 83.083 15.3632 90.5454 14.1811 95.9077Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M247.248 87.9621C247.248 88.7993 246.909 89.5643 246.347 90.12C245.799 90.6757 245.035 91.0221 244.199 91.0221H178.953C177.274 91.0221 175.904 89.6509 175.904 87.9693C175.904 87.1321 176.243 86.3671 176.805 85.8114C177.353 85.2557 178.117 84.9093 178.953 84.9093H182.038C183.256 82.073 186.067 80.0955 189.34 80.0955C191.545 80.0955 193.535 80.9976 194.976 82.4411C196.901 79.1789 200.44 76.9849 204.505 76.9849C205.622 76.9849 206.696 77.1509 207.705 77.4613C209.832 73.463 214.027 70.7422 218.863 70.7422C224.673 70.7422 229.56 74.6683 231.03 80.0161C232.097 79.4821 233.308 79.1717 234.591 79.1717C238.216 79.1717 241.273 81.5967 242.231 84.9093H244.199C245.871 84.9093 247.248 86.2877 247.248 87.9621Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M263.471 38.3676C260.941 38.3676 258.887 36.3107 258.887 33.7776C258.887 31.2444 260.941 29.1875 263.471 29.1875C266.001 29.1875 268.055 31.2444 268.055 33.7776C268.055 36.3107 266.001 38.3676 263.471 38.3676ZM263.471 30.6237C261.734 30.6237 260.321 32.0382 260.321 33.7776C260.321 35.5169 261.734 36.9314 263.471 36.9314C265.208 36.9314 266.621 35.5169 266.621 33.7776C266.621 32.0382 265.208 30.6237 263.471 30.6237Z" fill="#039D55"/>
      <path d="M279.975 54.477C277.445 54.477 275.391 52.4201 275.391 49.8869C275.391 47.3537 277.445 45.2969 279.975 45.2969C282.505 45.2969 284.559 47.3537 284.559 49.8869C284.559 52.4201 282.505 54.477 279.975 54.477ZM279.975 46.7331C278.238 46.7331 276.825 48.1476 276.825 49.8869C276.825 51.6262 278.238 53.0408 279.975 53.0408C281.712 53.0408 283.125 51.6262 283.125 49.8869C283.125 48.1476 281.712 46.7331 279.975 46.7331Z" fill="#039D55"/>
      <path d="M285.643 69.3924C285.246 69.3924 284.922 69.0676 284.922 68.6707V65.4951C284.922 65.0982 285.246 64.7734 285.643 64.7734C286.039 64.7734 286.363 65.0982 286.363 65.4951V68.6707C286.363 69.0676 286.039 69.3924 285.643 69.3924Z" fill="#039D55"/>
      <path d="M285.643 74.951C285.246 74.951 284.922 74.6262 284.922 74.2292V71.0537C284.922 70.6568 285.246 70.332 285.643 70.332C286.039 70.332 286.363 70.6568 286.363 71.0537V74.2292C286.363 74.6262 286.039 74.951 285.643 74.951Z" fill="#039D55"/>
      <path d="M290.095 70.584H287.248C286.852 70.584 286.527 70.2593 286.527 69.8623C286.527 69.4654 286.852 69.1406 287.248 69.1406H290.095C290.492 69.1406 290.816 69.4654 290.816 69.8623C290.816 70.2593 290.492 70.584 290.095 70.584Z" fill="#039D55"/>
      <path d="M284.035 70.584H281.188C280.791 70.584 280.467 70.2593 280.467 69.8623C280.467 69.4654 280.791 69.1406 281.188 69.1406H284.035C284.431 69.1406 284.755 69.4654 284.755 69.8623C284.755 70.2593 284.431 70.584 284.035 70.584Z" fill="#039D55"/>
      <path d="M260.32 51.5955C259.924 51.5955 259.6 51.2707 259.6 50.8738V47.6983C259.6 47.3013 259.924 46.9766 260.32 46.9766C260.717 46.9766 261.041 47.3013 261.041 47.6983V50.8738C261.041 51.2707 260.717 51.5955 260.32 51.5955Z" fill="#039D55"/>
      <path d="M260.32 57.1541C259.924 57.1541 259.6 56.8293 259.6 56.4324V53.2569C259.6 52.8599 259.924 52.5352 260.32 52.5352C260.717 52.5352 261.041 52.8599 261.041 53.2569V56.4324C261.041 56.8293 260.717 57.1541 260.32 57.1541Z" fill="#039D55"/>
      <path d="M264.775 52.7872H261.928C261.531 52.7872 261.207 52.4624 261.207 52.0655C261.207 51.6685 261.531 51.3438 261.928 51.3438H264.775C265.171 51.3438 265.496 51.6685 265.496 52.0655C265.496 52.4624 265.171 52.7872 264.775 52.7872Z" fill="#039D55"/>
      <path d="M258.72 52.7872H255.873C255.477 52.7872 255.152 52.4624 255.152 52.0655C255.152 51.6685 255.477 51.3438 255.873 51.3438H258.72C259.117 51.3438 259.441 51.6685 259.441 52.0655C259.441 52.4624 259.117 52.7872 258.72 52.7872Z" fill="#039D55"/>
      <path d="M44.3008 27.8049C44.3008 25.2717 46.355 23.2148 48.885 23.2148C51.415 23.2148 53.4692 25.2717 53.4692 27.8049C53.4692 30.3381 51.415 32.395 48.885 32.395C46.355 32.395 44.3008 30.3381 44.3008 27.8049ZM45.7424 27.8049C45.7424 29.5442 47.1551 30.9588 48.8922 30.9588C50.6293 30.9588 52.042 29.5442 52.042 27.8049C52.042 26.0656 50.6293 24.651 48.8922 24.651C47.1551 24.651 45.7424 26.0656 45.7424 27.8049Z" fill="#039D55"/>
      <path d="M25.8926 45.3088C25.8926 42.7756 27.9468 40.7188 30.4768 40.7188C33.0068 40.7188 35.061 42.7756 35.061 45.3088C35.061 47.842 33.0068 49.8989 30.4768 49.8989C27.9468 49.8989 25.8926 47.842 25.8926 45.3088ZM27.3342 45.3088C27.3342 47.0481 28.7469 48.4627 30.484 48.4627C32.2211 48.4627 33.6338 47.0481 33.6338 45.3088C33.6338 43.5695 32.2211 42.1549 30.484 42.1549C28.7469 42.1549 27.3342 43.5695 27.3342 45.3088Z" fill="#039D55"/>
      <path d="M16.3575 51.7517C16.7539 51.7517 17.0783 51.427 17.0783 51.03V47.8545C17.0783 47.4576 16.7539 47.1328 16.3575 47.1328C15.9611 47.1328 15.6367 47.4576 15.6367 47.8545V51.03C15.6367 51.427 15.9611 51.7517 16.3575 51.7517Z" fill="#039D55"/>
      <path d="M16.3575 57.3103C16.7539 57.3103 17.0783 56.9856 17.0783 56.5886V53.4131C17.0783 53.0162 16.7539 52.6914 16.3575 52.6914C15.9611 52.6914 15.6367 53.0162 15.6367 53.4131V56.5886C15.6367 56.9856 15.9611 57.3103 16.3575 57.3103Z" fill="#039D55"/>
      <path d="M11.9024 52.9434H14.7495C15.146 52.9434 15.4703 52.6186 15.4703 52.2217C15.4703 51.8248 15.146 51.5 14.7495 51.5H11.9024C11.506 51.5 11.1816 51.8248 11.1816 52.2217C11.1816 52.6186 11.506 52.9434 11.9024 52.9434Z" fill="#039D55"/>
      <path d="M17.9571 52.9434H20.8042C21.2007 52.9434 21.525 52.6186 21.525 52.2217C21.525 51.8248 21.2007 51.5 20.8042 51.5H17.9571C17.5607 51.5 17.2363 51.8248 17.2363 52.2217C17.2363 52.6186 17.5607 52.9434 17.9571 52.9434Z" fill="#039D55"/>
      <path d="M32.9278 27.3377C33.3243 27.3377 33.6486 27.0129 33.6486 26.616V23.4405C33.6486 23.0435 33.3243 22.7188 32.9278 22.7188C32.5314 22.7188 32.207 23.0435 32.207 23.4405V26.616C32.207 27.0129 32.5314 27.3377 32.9278 27.3377Z" fill="#039D55"/>
      <path d="M32.9278 32.8963C33.3243 32.8963 33.6486 32.5715 33.6486 32.1746V28.9991C33.6486 28.6021 33.3243 28.2773 32.9278 28.2773C32.5314 28.2773 32.207 28.6021 32.207 28.9991V32.1746C32.207 32.5715 32.5314 32.8963 32.9278 32.8963Z" fill="#039D55"/>
      <path d="M28.4806 28.5294H31.3277C31.7241 28.5294 32.0485 28.2046 32.0485 27.8076C32.0485 27.4107 31.7241 27.0859 31.3277 27.0859H28.4806C28.0841 27.0859 27.7598 27.4107 27.7598 27.8076C27.7598 28.2046 28.0841 28.5294 28.4806 28.5294Z" fill="#039D55"/>
      <path d="M34.5352 28.5294H37.3824C37.7788 28.5294 38.1031 28.2046 38.1031 27.8076C38.1031 27.4107 37.7788 27.0859 37.3824 27.0859H34.5352C34.1388 27.0859 33.8145 27.4107 33.8145 27.8076C33.8145 28.2046 34.1388 28.5294 34.5352 28.5294Z" fill="#039D55"/>
      <path d="M213.174 44.5577V57.8443C213.174 59.5981 211.754 61.0271 209.996 61.0271H185.9L178.627 63.6396C177.877 63.9067 177.164 63.1705 177.452 62.4344L180.206 55.3184V44.5577C180.206 42.804 181.626 41.375 183.384 41.375H209.996C211.747 41.375 213.174 42.7968 213.174 44.5577Z" fill="#039D55"/>
      <g opacity="0.5">
      <path d="M208.099 48.3196H185.993C185.51 48.3196 185.113 47.9298 185.113 47.4391C185.113 46.9555 185.503 46.5586 185.993 46.5586H208.099C208.582 46.5586 208.979 46.9483 208.979 47.4391C208.979 47.9226 208.589 48.3196 208.099 48.3196Z" fill="#090909"/>
      <path d="M208.099 51.8547H185.993C185.51 51.8547 185.113 51.465 185.113 50.9742C185.113 50.4907 185.503 50.0938 185.993 50.0938H208.099C208.582 50.0938 208.979 50.4835 208.979 50.9742C208.979 51.4578 208.589 51.8547 208.099 51.8547Z" fill="#090909"/>
      <path d="M208.099 55.3938H185.993C185.51 55.3938 185.113 55.0041 185.113 54.5133C185.113 54.0298 185.503 53.6328 185.993 53.6328H208.099C208.582 53.6328 208.979 54.0225 208.979 54.5133C208.979 54.9968 208.589 55.3938 208.099 55.3938Z" fill="#090909"/>
      </g>
      <path d="M121.231 11.4899C121.31 11.5115 121.389 11.5115 121.476 11.4899C122.355 11.2589 122.867 11.1651 122.867 11.1651C123.133 11.1146 123.306 10.862 123.263 10.595C123.213 10.3279 122.96 10.1547 122.694 10.198C122.672 10.198 122.146 10.2991 121.231 10.5372C120.971 10.6094 120.813 10.8764 120.885 11.1362C120.935 11.3167 121.072 11.4466 121.238 11.4899H121.231Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M92.7902 33.9554C92.3361 34.7853 91.8964 35.6514 91.4856 36.5247C91.3846 36.7412 91.1468 36.8494 90.9233 36.7917C90.8945 36.7845 90.8657 36.77 90.8368 36.7628C90.5918 36.6473 90.4909 36.3514 90.6062 36.1133C91.0242 35.2256 91.4711 34.3451 91.9396 33.4935C92.0694 33.2553 92.3649 33.1687 92.6028 33.2986C92.8406 33.4285 92.9271 33.7244 92.7974 33.9626L92.7902 33.9554Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M90.3313 39.1621C89.9781 40.0426 89.6393 40.9519 89.3366 41.8685C89.2573 42.1139 88.9978 42.251 88.7527 42.186C88.7383 42.186 88.7311 42.186 88.7167 42.1716C88.4572 42.085 88.3203 41.8035 88.4068 41.5509C88.7239 40.6199 89.0627 39.6889 89.4231 38.794C89.524 38.5414 89.8123 38.4187 90.0574 38.5198C90.3096 38.6208 90.4322 38.9095 90.3313 39.1549V39.1621Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M86.1796 53.5243C85.9417 53.4666 85.7831 53.2357 85.812 52.9903C85.9345 52.016 86.0859 51.0417 86.2517 50.089C86.2949 49.822 86.5544 49.6416 86.8211 49.6921C87.0878 49.7426 87.268 49.9952 87.2175 50.2622C87.0517 51.1932 86.9076 52.1603 86.785 53.1202C86.749 53.3872 86.5039 53.5749 86.2372 53.546C86.2156 53.546 86.2012 53.546 86.1796 53.5316V53.5243Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M88.1467 44.0177C88.4061 44.0899 88.5575 44.3641 88.4854 44.624C88.3629 45.057 88.2476 45.49 88.1395 45.9158C88.0169 46.4138 87.8944 46.919 87.7791 47.417C87.7214 47.684 87.4547 47.85 87.1952 47.785C87.1952 47.785 87.188 47.785 87.1808 47.785C86.9213 47.7201 86.7628 47.4603 86.8204 47.2004C86.9357 46.688 87.0583 46.1756 87.188 45.6704C87.2961 45.2374 87.4187 44.7899 87.5412 44.3497C87.6133 44.0899 87.8728 43.9383 88.1322 44.0033C88.1322 44.0033 88.1395 44.0033 88.1467 44.0033V44.0177Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M94.253 31.4732C94.1377 31.6536 93.9214 31.7402 93.7196 31.6897C93.6692 31.6753 93.6259 31.6608 93.5755 31.632C93.3448 31.4876 93.2799 31.1845 93.4241 30.9536C93.9431 30.1236 94.4981 29.3081 95.0747 28.5214C95.2333 28.3049 95.536 28.2544 95.7594 28.4132C95.9757 28.5719 96.0261 28.8751 95.8676 29.0988C95.3053 29.871 94.7648 30.6721 94.253 31.4804V31.4732Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M118.723 12.3203C117.829 12.6234 116.921 12.9698 116.027 13.3379C115.926 13.3812 115.818 13.3884 115.717 13.3595C115.573 13.3234 115.443 13.2224 115.386 13.0708C115.285 12.8182 115.4 12.5368 115.652 12.4285C116.568 12.0532 117.49 11.6996 118.406 11.3893C118.658 11.3027 118.939 11.4398 119.026 11.6924C119.112 11.945 118.975 12.2264 118.723 12.3131V12.3203Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M110.846 15.8498C110.73 15.9148 110.601 15.9292 110.485 15.9004C110.363 15.8715 110.247 15.7849 110.175 15.6622C110.046 15.424 110.125 15.1281 110.363 14.9982C111.213 14.5219 112.093 14.0672 112.972 13.6414C113.217 13.5259 113.505 13.627 113.628 13.8724C113.743 14.1177 113.642 14.4064 113.397 14.5291C112.539 14.9477 111.675 15.3952 110.846 15.857V15.8498Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M101.561 22.6206C101.431 22.736 101.266 22.7793 101.107 22.736C101.02 22.7144 100.934 22.6639 100.869 22.5989C100.682 22.404 100.696 22.0937 100.891 21.9061C101.604 21.2421 102.347 20.5853 103.096 19.9647C103.305 19.7915 103.615 19.8203 103.788 20.0296C103.961 20.2389 103.932 20.5493 103.723 20.7225C102.988 21.3359 102.26 21.971 101.561 22.6278V22.6206Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M105.994 18.9522C105.872 19.0388 105.72 19.0677 105.583 19.0316C105.475 19.0027 105.374 18.9378 105.31 18.844C105.151 18.6274 105.201 18.3171 105.418 18.1583C106.203 17.5882 107.018 17.0253 107.847 16.4984C108.077 16.3541 108.38 16.419 108.524 16.65C108.668 16.8809 108.604 17.184 108.373 17.3284C107.566 17.848 106.766 18.3893 105.994 18.9522Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M97.6198 26.8112C97.4973 26.9628 97.3027 27.0205 97.1225 26.9772C97.0576 26.9628 96.9855 26.9267 96.9278 26.8762C96.7188 26.7029 96.69 26.3926 96.863 26.1833C97.4828 25.4327 98.1388 24.6894 98.8091 23.9749C98.9965 23.78 99.3064 23.7656 99.5011 23.9532C99.6957 24.1409 99.7101 24.4512 99.5227 24.6461C98.8668 25.3389 98.2253 26.0678 97.6198 26.804V26.8112Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M121.714 8.16972L120.727 0L146.682 3.96939L121.714 8.16972Z" fill="#039D55"/>
      <path d="M146.683 3.96875L122.702 10.2476L122.637 10.2692L121.434 11.7415L121.715 8.16908L146.683 3.96875Z" fill="#090909"/>
      <path d="M125.657 9.47537L122.637 10.2692L127.545 17.7173L146.682 3.96875L125.657 9.47537Z" fill="#039D55"/>
      <path d="M245.891 157.711C252.204 150.3 265.918 133.011 273.945 113.954C285.46 86.6001 299.169 87.9385 302.525 97.0469C311.2 120.606 272.718 149.82 256.677 160.747L245.896 157.711H245.891Z" fill="white"/>
      <path d="M245.891 157.711C252.204 150.3 265.918 133.011 273.945 113.954C285.46 86.6001 299.169 87.9385 302.525 97.0469C311.2 120.606 272.718 149.82 256.677 160.747L245.896 157.711H245.891Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M249.688 158.785C260.798 149.056 269.97 137.845 276.139 129.443C284.39 118.209 289.211 109.431 289.263 109.344C289.437 109.031 289.83 108.915 290.148 109.089C290.467 109.263 290.582 109.657 290.409 109.969C290.362 110.056 285.507 118.898 277.209 130.202C271.11 138.505 262.106 149.532 251.186 159.214L249.693 158.791L249.688 158.785Z" fill="#039D55"/>
      <path d="M252.998 134.309C255.167 128.901 259.202 117.617 260.177 106.357C261.637 89.5312 269.129 87.8701 272.455 92.2233C281.589 104.176 263.615 128.839 257.845 136.176L252.998 134.314V134.309Z" fill="white"/>
      <path d="M252.998 134.309C255.167 128.901 259.202 117.617 260.177 106.357C261.637 89.5312 269.129 87.8701 272.455 92.2233C281.589 104.176 263.615 128.839 257.845 136.176L252.998 134.314V134.309Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M249.984 146.33C256.608 135.367 261.221 123.669 264.09 115.102C267.903 103.728 269.547 95.2623 269.561 95.1829C269.619 94.8798 269.914 94.6777 270.217 94.7426C270.52 94.8004 270.721 95.0963 270.664 95.3994C270.649 95.486 268.992 104.002 265.157 115.448C262.281 124.029 257.668 135.736 251.051 146.742L249.984 146.345V146.33Z" fill="#090909"/>
      <path d="M294.358 183.769C296.823 170.714 301.551 158.798 306.936 163.713C312.32 168.635 303.786 188.973 291.057 200.246L287.64 205.117C296.773 196.738 311.469 191.744 315.463 196.479C319.427 201.177 309.343 203.616 299.757 204.302C292.462 204.821 287.806 206.842 285.55 208.098L269.419 231.106C283.921 217.884 307.13 210.018 313.444 217.509C319.737 224.972 303.735 228.833 288.527 229.922C277.037 230.745 269.671 233.906 266.06 235.905L262.845 240.495C261.966 240.062 261.086 239.622 260.207 239.182L279.394 211.808C279.51 208.993 279.243 205.016 277.852 200.058C275.243 190.799 274.104 180.478 279.863 182.615C284.865 184.469 285.781 196.276 282.883 206.835L289.521 197.366C291.078 194.09 293.306 189.413 294.365 183.777L294.358 183.769Z" fill="white"/>
      <path d="M294.358 183.769C296.823 170.714 301.551 158.798 306.936 163.713C312.32 168.635 303.786 188.973 291.057 200.246L287.64 205.117C296.773 196.738 311.469 191.744 315.463 196.479C319.427 201.177 309.343 203.616 299.757 204.302C292.462 204.821 287.806 206.842 285.55 208.098L269.419 231.106C283.921 217.884 307.13 210.018 313.444 217.509C319.737 224.972 303.735 228.833 288.527 229.922C277.037 230.745 269.671 233.906 266.06 235.905L262.845 240.495C261.966 240.062 261.086 239.622 260.207 239.182L279.394 211.808C279.51 208.993 279.243 205.016 277.852 200.058C275.243 190.799 274.104 180.478 279.863 182.615C284.865 184.469 285.781 196.276 282.883 206.835L289.521 197.366C291.078 194.09 293.306 189.413 294.365 183.777L294.358 183.769Z" fill="#039D55" fill-opacity="0.5"/>
      <path d="M40.2291 79.3439C38.9244 68.5327 35.7025 58.5299 31.039 62.2611C26.3683 65.9923 32.2355 83.0895 42.031 92.9986L44.561 97.17C37.5477 89.8231 25.7989 84.9299 22.2815 88.5817C18.7856 92.2119 26.8945 94.7523 34.6934 95.8349C40.6327 96.6576 44.3231 98.5629 46.1035 99.7176L58.0397 119.413C46.9036 107.808 28.3505 100.115 22.786 105.888C17.2359 111.647 30.1092 115.682 42.4851 117.399C51.8337 118.699 57.6865 121.686 60.5336 123.52L62.9122 127.446C63.6547 127.142 64.3971 126.832 65.1395 126.515L50.94 103.081C51.0048 100.771 51.4301 97.5381 52.8428 93.5615C55.4809 86.1351 56.9802 77.7561 52.1509 79.1851C47.9631 80.4264 46.572 90.0323 48.3668 98.8299L43.4582 90.7252C42.3698 87.961 40.7985 84.0133 40.2363 79.3439H40.2291Z" fill="white"/>
      <path d="M40.2291 79.3439C38.9244 68.5327 35.7025 58.5299 31.039 62.2611C26.3683 65.9923 32.2355 83.0895 42.031 92.9986L44.561 97.17C37.5477 89.8231 25.7989 84.9299 22.2815 88.5817C18.7856 92.2119 26.8945 94.7523 34.6934 95.8349C40.6327 96.6576 44.3231 98.5629 46.1035 99.7176L58.0397 119.413C46.9036 107.808 28.3505 100.115 22.786 105.888C17.2359 111.647 30.1092 115.682 42.4851 117.399C51.8337 118.699 57.6865 121.686 60.5336 123.52L62.9122 127.446C63.6547 127.142 64.3971 126.832 65.1395 126.515L50.94 103.081C51.0048 100.771 51.4301 97.5381 52.8428 93.5615C55.4809 86.1351 56.9802 77.7561 52.1509 79.1851C47.9631 80.4264 46.572 90.0323 48.3668 98.8299L43.4582 90.7252C42.3698 87.961 40.7985 84.0133 40.2363 79.3439H40.2291Z" fill="#039D55" fill-opacity="0.7"/>
      <path d="M293.456 242.284V242.537H12.5938V242.284C12.5938 239.405 14.9291 237.066 17.805 237.066H288.244C291.128 237.066 293.456 239.405 293.456 242.284Z" fill="#039D55"/>
      <g clip-path="url(#clip1_2950_15049)">
      <path d="M119.606 94.5994L84.3474 106.522C83.9178 106.668 83.4427 106.534 83.1532 106.186C82.8621 105.839 82.8165 105.348 83.0368 104.952L91.7987 89.244C92.0536 88.7874 92.5948 88.574 93.0935 88.734L98.5514 90.4867L101.816 85.7841C102.113 85.3541 102.675 85.1956 103.155 85.4028L119.691 92.558C120.106 92.7384 120.369 93.1542 120.35 93.6061C120.331 94.0596 120.035 94.4535 119.606 94.5994ZM86.3376 103.539L116.209 93.4382L103.109 87.769L99.895 92.4011C99.6197 92.798 99.1162 92.9675 98.6568 92.82L93.2808 91.094L86.3376 103.539Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M84.3463 106.521C84.2047 106.569 84.0505 106.588 83.8947 106.574C83.462 106.535 83.0939 106.246 82.9554 105.835L75.8864 85.0425C75.7527 84.6503 75.8534 84.2188 76.1429 83.9238C76.434 83.6288 76.8666 83.5236 77.2615 83.6507L93.0924 88.7347C93.4055 88.8351 93.6557 89.0705 93.7768 89.3749C93.898 89.6793 93.8744 90.0214 93.7155 90.3085L84.9536 106.017C84.8183 106.259 84.5996 106.434 84.3463 106.521ZM78.665 86.3998L84.2393 102.796L91.1478 90.4074L78.665 86.3998Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M119.607 94.5985C119.354 94.6848 119.072 94.6769 118.817 94.5655L102.281 87.4103C101.979 87.2801 101.753 87.0212 101.663 86.7074C101.573 86.392 101.629 86.053 101.816 85.7847L111.283 72.1475C111.519 71.807 111.926 71.6297 112.337 71.6861C112.747 71.7442 113.09 72.0266 113.224 72.4189L120.293 93.2114C120.433 93.6209 120.317 94.0744 119.997 94.3678C119.884 94.4729 119.75 94.5498 119.607 94.5985ZM104.382 85.9338L117.42 91.5763L111.846 75.1806L104.382 85.9338Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M99.3432 92.8138C99.1261 92.8875 98.8854 92.8922 98.6541 92.8185L76.5896 85.7339C76.1397 85.5895 75.8329 85.1721 75.8281 84.7014C75.825 84.2291 76.1255 83.8086 76.5723 83.6564L111.831 71.7342C112.279 71.582 112.775 71.7342 113.06 72.1108C113.344 72.4874 113.355 73.0052 113.086 73.3927L99.8923 92.3995C99.7554 92.5988 99.5619 92.74 99.3432 92.8138ZM80.4239 84.6653L98.5534 90.4868L109.394 74.8693L80.4239 84.6653Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M116.534 216.03L79.2965 234.455C78.8433 234.679 78.2974 234.603 77.9245 234.261C77.5516 233.918 77.4273 233.383 77.6114 232.914L84.9636 214.231C85.1776 213.688 85.7456 213.371 86.3198 213.474L92.621 214.604L95.5317 208.916C95.7976 208.397 96.3939 208.138 96.9556 208.296L116.32 213.762C116.808 213.9 117.16 214.322 117.206 214.824C117.256 215.326 116.989 215.806 116.534 216.03ZM81.0539 230.859L112.601 215.249L97.2592 210.92L94.3926 216.522C94.1472 217.002 93.6154 217.264 93.0852 217.168L86.8784 216.056L81.0539 230.859Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M79.298 234.458C79.147 234.531 78.9818 234.577 78.8071 234.583C78.3225 234.603 77.8726 234.338 77.657 233.905L66.7334 211.945C66.5273 211.531 66.5729 211.038 66.8514 210.668C67.1298 210.299 67.5924 210.117 68.0471 210.199L86.3229 213.475C86.6832 213.54 86.9963 213.762 87.1757 214.083C87.355 214.401 87.3802 214.784 87.2465 215.124L79.8943 233.808C79.7794 234.097 79.5655 234.326 79.298 234.458ZM70.009 213.034L78.623 230.351L84.4208 215.619L70.009 213.034Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M116.537 216.031C116.269 216.163 115.958 216.196 115.659 216.113L96.2944 210.648C95.9419 210.549 95.6525 210.296 95.5046 209.96C95.3582 209.625 95.3693 209.242 95.536 208.917L103.977 192.421C104.188 192.01 104.613 191.752 105.075 191.754C105.538 191.757 105.959 192.019 106.165 192.433L117.089 214.393C117.305 214.826 117.243 215.344 116.935 215.716C116.823 215.851 116.686 215.958 116.537 216.031ZM98.3963 208.702L113.667 213.011L105.052 195.696L98.3963 208.702Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M93.8473 217.061C93.6176 217.174 93.3517 217.216 93.0858 217.169L67.6135 212.603C67.0928 212.51 66.6916 212.095 66.6176 211.572C66.5437 211.051 66.8127 210.54 67.2863 210.306L104.522 191.881C104.996 191.647 105.567 191.741 105.938 192.117C106.31 192.492 106.398 193.061 106.159 193.53L94.3948 216.521C94.2705 216.761 94.077 216.946 93.8473 217.061ZM71.6948 210.852L92.6248 214.604L102.291 195.713L71.6948 210.852Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M236.029 188.908L198.044 172.575C197.582 172.376 197.289 171.913 197.31 171.411C197.33 170.909 197.657 170.471 198.134 170.308L217.085 163.851C217.635 163.663 218.241 163.89 218.534 164.392L221.729 169.889L227.931 168.433C228.498 168.299 229.078 168.585 229.321 169.112L237.623 187.289C237.832 187.747 237.736 188.285 237.384 188.643C237.03 189.002 236.492 189.107 236.029 188.908ZM201.912 171.59L234.093 185.428L227.514 171.028L221.407 172.462C220.884 172.585 220.342 172.352 220.073 171.888L216.926 166.473L201.912 171.59Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M198.045 172.577C197.892 172.511 197.751 172.414 197.633 172.286C197.306 171.933 197.217 171.422 197.408 170.979L207.092 148.579C207.274 148.156 207.679 147.874 208.14 147.846C208.599 147.819 209.035 148.053 209.266 148.45L218.533 164.394C218.715 164.709 218.749 165.089 218.62 165.429C218.492 165.77 218.217 166.037 217.872 166.154L198.921 172.611C198.63 172.71 198.319 172.693 198.045 172.577ZM208.372 151.759L200.735 169.424L215.679 164.333L208.372 151.759Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M236.031 188.909C235.759 188.792 235.532 188.577 235.405 188.297L227.102 170.121C226.951 169.79 226.956 169.408 227.116 169.082C227.277 168.755 227.576 168.517 227.931 168.434L245.918 164.208C246.366 164.103 246.835 164.258 247.131 164.61C247.426 164.961 247.499 165.451 247.316 165.871L237.632 188.272C237.442 188.713 237.008 189.002 236.525 189.007C236.353 189.01 236.185 188.975 236.031 188.909ZM229.936 170.461L236.482 184.793L244.119 167.128L229.936 170.461Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M220.645 172.398C220.411 172.297 220.208 172.123 220.072 171.891L207.157 149.669C206.893 149.216 206.951 148.644 207.3 148.252C207.649 147.86 208.211 147.736 208.694 147.943L246.679 164.276C247.162 164.483 247.456 164.976 247.411 165.498C247.365 166.021 246.987 166.455 246.476 166.575L221.408 172.464C221.145 172.525 220.879 172.498 220.645 172.398ZM211.115 151.632L221.729 169.892L242.327 165.054L211.115 151.632Z" fill="#039D55" fill-opacity="0.3"/>
      <path d="M90.204 187.24H90.1537C89.9397 187.239 89.7682 187.066 89.7682 186.853C89.7698 186.641 89.9428 186.468 90.1552 186.468H90.1568H90.204C91.222 186.468 92.2509 186.407 93.2626 186.288C93.475 186.263 93.6669 186.413 93.6921 186.625C93.7173 186.837 93.5662 187.028 93.3538 187.053C92.3123 187.177 91.2534 187.24 90.204 187.24ZM85.753 186.864C85.731 186.864 85.709 186.862 85.687 186.857C84.6407 186.678 83.5897 186.435 82.5655 186.132C82.3609 186.071 82.2429 185.858 82.3043 185.652C82.3657 185.448 82.5796 185.331 82.7857 185.392C83.7801 185.685 84.8012 185.922 85.8176 186.096C86.0284 186.132 86.17 186.332 86.1338 186.542C86.1023 186.73 85.9387 186.864 85.753 186.864ZM97.638 186.176C97.4712 186.176 97.3155 186.066 97.2667 185.899C97.2069 185.695 97.3249 185.48 97.5294 185.42C98.5206 185.13 99.5071 184.778 100.459 184.373C100.656 184.29 100.882 184.381 100.967 184.577C101.051 184.774 100.959 184.999 100.763 185.084C99.7825 185.502 98.7677 185.864 97.7466 186.162C97.7104 186.17 97.6742 186.176 97.638 186.176ZM78.5566 184.557C78.5 184.557 78.4418 184.544 78.3883 184.518C77.4301 184.053 76.4893 183.526 75.5956 182.952C75.4162 182.836 75.3643 182.597 75.4792 182.418C75.5956 182.239 75.8348 182.188 76.0141 182.302C76.8826 182.859 77.7951 183.372 78.7265 183.823C78.9185 183.915 78.9987 184.147 78.9059 184.339C78.8382 184.477 78.6998 184.557 78.5566 184.557ZM104.518 183.054C104.391 183.054 104.266 182.991 104.193 182.876C104.078 182.698 104.13 182.457 104.311 182.343C105.182 181.787 106.03 181.172 106.829 180.518C106.995 180.383 107.238 180.407 107.374 180.571C107.509 180.736 107.485 180.979 107.32 181.114C106.497 181.787 105.626 182.42 104.727 182.993C104.661 183.035 104.589 183.054 104.518 183.054ZM72.3026 180.325C72.2098 180.325 72.1154 180.292 72.0414 180.225C71.2548 179.509 70.5043 178.739 69.8073 177.932C69.6673 177.771 69.6862 177.527 69.8482 177.388C70.0103 177.248 70.2541 177.267 70.3942 177.428C71.0707 178.21 71.8007 178.96 72.5638 179.655C72.7211 179.799 72.7321 180.043 72.589 180.2C72.5119 180.283 72.4065 180.325 72.3026 180.325ZM110.244 178.131C110.154 178.131 110.063 178.1 109.99 178.037C109.83 177.898 109.812 177.653 109.952 177.493C110.632 176.714 111.271 175.886 111.853 175.032C111.973 174.857 112.213 174.81 112.391 174.93C112.567 175.05 112.615 175.29 112.493 175.467C111.896 176.346 111.236 177.198 110.538 178C110.459 178.087 110.351 178.131 110.244 178.131ZM67.5024 174.5C67.3718 174.5 67.2444 174.435 67.172 174.315C66.6197 173.407 66.1147 172.457 65.6742 171.491C65.5861 171.296 65.671 171.069 65.8661 170.979C66.0612 170.891 66.2893 170.976 66.379 171.171C66.807 172.109 67.2979 173.033 67.8344 173.915C67.9445 174.097 67.8863 174.334 67.7038 174.446C67.6393 174.483 67.57 174.5 67.5024 174.5ZM114.339 171.794C114.285 171.794 114.23 171.783 114.178 171.759C113.985 171.671 113.898 171.442 113.988 171.248C114.418 170.312 114.795 169.338 115.113 168.354L115.124 168.32C115.189 168.117 115.407 168.004 115.61 168.07C115.813 168.135 115.926 168.353 115.86 168.555L115.849 168.59C115.522 169.605 115.132 170.607 114.691 171.569C114.625 171.711 114.485 171.794 114.339 171.794ZM64.5335 167.568C64.362 167.568 64.2062 167.454 64.1606 167.283C63.8853 166.256 63.6697 165.203 63.5187 164.154C63.4888 163.943 63.6351 163.747 63.8475 163.717C64.0599 163.688 64.255 163.834 64.2849 164.045C64.4312 165.065 64.6405 166.088 64.908 167.085C64.963 167.29 64.8403 167.502 64.6342 167.557C64.5996 167.565 64.5665 167.568 64.5335 167.568ZM116.488 164.529C116.469 164.529 116.45 164.527 116.431 164.524C116.221 164.493 116.073 164.298 116.104 164.086C116.254 163.065 116.342 162.024 116.367 160.993C116.372 160.78 116.548 160.612 116.763 160.617C116.977 160.622 117.146 160.799 117.141 161.012C117.114 162.073 117.023 163.145 116.87 164.198C116.844 164.391 116.678 164.529 116.488 164.529ZM63.643 160.085C63.6399 160.085 63.6367 160.085 63.6336 160.085C63.4196 160.08 63.2512 159.903 63.256 159.69C63.2827 158.629 63.3755 157.557 63.5297 156.504C63.5612 156.294 63.7563 156.148 63.9687 156.178C64.1795 156.209 64.3258 156.404 64.2959 156.616C64.1465 157.637 64.0568 158.677 64.03 159.708C64.0237 159.919 63.8507 160.085 63.643 160.085ZM116.493 156.991C116.304 156.991 116.139 156.853 116.111 156.66C115.963 155.64 115.753 154.618 115.484 153.62C115.429 153.415 115.552 153.203 115.758 153.148C115.964 153.093 116.177 153.215 116.232 153.421C116.507 154.447 116.724 155.5 116.877 156.55C116.907 156.76 116.76 156.956 116.549 156.986C116.531 156.991 116.512 156.991 116.493 156.991ZM64.9111 152.652C64.8718 152.652 64.8324 152.646 64.7931 152.633C64.5901 152.569 64.4769 152.351 64.5429 152.148L64.5492 152.129C64.8733 151.124 65.2604 150.126 65.6993 149.169C65.7874 148.974 66.0172 148.889 66.2123 148.977C66.4073 149.065 66.4923 149.294 66.4042 149.489C65.9778 150.419 65.6018 151.387 65.2871 152.366L65.2808 152.384C65.2273 152.548 65.0747 152.652 64.9111 152.652ZM114.364 149.76C114.218 149.76 114.076 149.677 114.012 149.534C113.582 148.596 113.093 147.673 112.555 146.791C112.443 146.609 112.501 146.372 112.684 146.261C112.866 146.15 113.104 146.208 113.216 146.39C113.769 147.297 114.273 148.247 114.715 149.214C114.803 149.409 114.718 149.636 114.523 149.726C114.473 149.749 114.418 149.76 114.364 149.76ZM68.2151 145.873C68.1412 145.873 68.0656 145.851 67.998 145.807C67.8218 145.688 67.7746 145.448 67.8941 145.271C68.492 144.392 69.1497 143.539 69.8482 142.737C69.9882 142.577 70.2321 142.559 70.3942 142.699C70.5547 142.839 70.572 143.082 70.4319 143.244C69.7522 144.023 69.1135 144.85 68.5345 145.706C68.4605 145.814 68.3394 145.873 68.2151 145.873ZM110.284 143.413C110.176 143.413 110.067 143.368 109.992 143.28C109.315 142.498 108.584 141.75 107.821 141.055C107.663 140.912 107.651 140.667 107.795 140.51C107.939 140.353 108.184 140.341 108.341 140.485C109.128 141.201 109.88 141.971 110.577 142.776C110.717 142.938 110.698 143.181 110.538 143.32C110.465 143.383 110.374 143.413 110.284 143.413ZM73.3096 140.301C73.1978 140.301 73.0877 140.253 73.0106 140.16C72.8753 139.995 72.8989 139.752 73.0641 139.617C73.8854 138.943 74.7586 138.31 75.6554 137.737C75.8348 137.623 76.0739 137.675 76.1903 137.854C76.3052 138.032 76.2533 138.271 76.0739 138.387C75.2023 138.944 74.3542 139.558 73.5566 140.214C73.4826 140.273 73.3961 140.301 73.3096 140.301ZM104.576 138.47C104.504 138.47 104.432 138.45 104.367 138.409C103.499 137.852 102.585 137.341 101.653 136.89C101.461 136.798 101.381 136.567 101.474 136.374C101.567 136.182 101.798 136.102 101.991 136.195C102.951 136.66 103.89 137.185 104.786 137.759C104.965 137.874 105.017 138.114 104.902 138.293C104.83 138.408 104.704 138.47 104.576 138.47ZM79.7697 136.386C79.6202 136.386 79.477 136.299 79.4141 136.153C79.3307 135.957 79.422 135.731 79.617 135.646C80.5957 135.228 81.6105 134.864 82.6316 134.566C82.8361 134.507 83.0516 134.623 83.1114 134.828C83.1712 135.032 83.0548 135.247 82.8487 135.307C81.8575 135.597 80.871 135.95 79.9207 136.355C79.8719 136.377 79.82 136.386 79.7697 136.386ZM97.7025 135.34C97.6663 135.34 97.6301 135.335 97.5924 135.324C96.5965 135.031 95.5769 134.795 94.5606 134.623C94.3497 134.587 94.2081 134.387 94.2443 134.177C94.2805 133.967 94.4803 133.826 94.6912 133.862C95.7374 134.039 96.7884 134.282 97.8126 134.584C98.0172 134.643 98.1352 134.858 98.0738 135.062C98.0235 135.23 97.8693 135.34 97.7025 135.34ZM87.0684 134.438C86.8748 134.438 86.7081 134.293 86.6845 134.097C86.6593 133.885 86.8103 133.694 87.0227 133.669C88.0706 133.545 89.1357 133.48 90.1898 133.48H90.1914H90.2213C90.4353 133.48 90.6084 133.653 90.6084 133.866C90.6084 134.08 90.4353 134.252 90.2213 134.252H90.1914H90.1898C89.1672 134.252 88.1319 134.314 87.114 134.434C87.0998 134.438 87.0841 134.438 87.0684 134.438Z" fill="#039D55"/>
      <path d="M210.173 221.666C209.891 221.666 209.66 221.44 209.657 221.158C209.653 220.874 209.882 220.64 210.166 220.637C211.238 220.625 212.32 220.582 213.385 220.51C213.67 220.49 213.916 220.705 213.934 220.989C213.953 221.273 213.739 221.517 213.455 221.536C212.371 221.61 211.269 221.654 210.179 221.666C210.177 221.666 210.176 221.666 210.173 221.666ZM205.627 221.541C205.616 221.541 205.604 221.541 205.593 221.539C204.505 221.467 203.407 221.362 202.33 221.229C202.046 221.194 201.846 220.937 201.881 220.654C201.916 220.372 202.174 220.173 202.457 220.207C203.516 220.339 204.595 220.441 205.662 220.512C205.947 220.53 206.161 220.775 206.142 221.059C206.123 221.332 205.896 221.541 205.627 221.541ZM217.942 221.051C217.69 221.051 217.47 220.868 217.432 220.612C217.389 220.331 217.585 220.069 217.866 220.028C218.925 219.871 219.992 219.683 221.036 219.467C221.316 219.408 221.589 219.587 221.647 219.867C221.705 220.144 221.526 220.417 221.246 220.475C220.181 220.695 219.095 220.888 218.017 221.047C217.994 221.05 217.967 221.051 217.942 221.051ZM197.905 220.496C197.871 220.496 197.836 220.493 197.8 220.485C196.733 220.265 195.66 220.013 194.609 219.733C194.334 219.66 194.17 219.379 194.244 219.104C194.318 218.829 194.6 218.666 194.875 218.74C195.907 219.015 196.961 219.263 198.009 219.478C198.288 219.536 198.469 219.807 198.41 220.085C198.36 220.33 198.144 220.496 197.905 220.496ZM225.555 219.387C225.332 219.387 225.126 219.241 225.059 219.016C224.979 218.743 225.137 218.458 225.41 218.378C226.436 218.078 227.467 217.745 228.474 217.387C228.743 217.292 229.037 217.431 229.133 217.7C229.229 217.968 229.089 218.261 228.82 218.357C227.794 218.721 226.744 219.06 225.7 219.365C225.653 219.38 225.604 219.387 225.555 219.387ZM190.397 218.407C190.341 218.407 190.282 218.398 190.224 218.378C189.195 218.014 188.165 217.615 187.161 217.194C186.898 217.085 186.776 216.782 186.886 216.521C186.996 216.259 187.298 216.137 187.561 216.247C188.547 216.661 189.559 217.052 190.569 217.409C190.838 217.505 190.978 217.799 190.882 218.067C190.808 218.276 190.61 218.407 190.397 218.407ZM232.865 216.699C232.668 216.699 232.479 216.586 232.394 216.394C232.278 216.135 232.394 215.831 232.654 215.715C233.628 215.279 234.602 214.809 235.549 214.318C235.802 214.188 236.114 214.285 236.244 214.538C236.375 214.791 236.277 215.101 236.024 215.231C235.06 215.73 234.068 216.209 233.077 216.653C233.008 216.684 232.936 216.699 232.865 216.699ZM183.24 215.308C183.16 215.308 183.08 215.29 183.003 215.25C182.035 214.75 181.071 214.215 180.133 213.661C179.887 213.516 179.807 213.199 179.952 212.956C180.097 212.711 180.413 212.631 180.658 212.776C181.579 213.32 182.528 213.846 183.476 214.337C183.73 214.467 183.827 214.778 183.697 215.031C183.607 215.206 183.426 215.308 183.24 215.308ZM239.734 213.041C239.562 213.041 239.394 212.955 239.297 212.799C239.146 212.558 239.219 212.241 239.46 212.09C240.365 211.525 241.266 210.927 242.14 210.312C242.372 210.148 242.693 210.204 242.859 210.435C243.024 210.667 242.967 210.987 242.736 211.152C241.847 211.778 240.93 212.388 240.008 212.963C239.923 213.016 239.828 213.041 239.734 213.041ZM176.577 211.263C176.475 211.263 176.371 211.232 176.28 211.169C175.391 210.543 174.508 209.882 173.656 209.206C173.432 209.029 173.396 208.705 173.572 208.483C173.75 208.26 174.074 208.224 174.297 208.4C175.134 209.063 176.003 209.713 176.876 210.328C177.109 210.493 177.164 210.813 177 211.045C176.898 211.188 176.739 211.263 176.577 211.263ZM246.045 208.483C245.897 208.483 245.75 208.42 245.648 208.298C245.466 208.079 245.495 207.755 245.714 207.573C246.535 206.89 247.347 206.175 248.128 205.448C248.335 205.253 248.663 205.264 248.856 205.473C249.051 205.68 249.04 206.007 248.831 206.2C248.036 206.94 247.209 207.668 246.373 208.363C246.277 208.443 246.161 208.483 246.045 208.483ZM170.529 206.355C170.403 206.355 170.278 206.309 170.177 206.217C169.382 205.476 168.597 204.703 167.844 203.918C167.647 203.713 167.653 203.388 167.859 203.19C168.065 202.994 168.391 203 168.589 203.206C169.329 203.976 170.1 204.736 170.88 205.464C171.088 205.658 171.1 205.983 170.905 206.19C170.805 206.3 170.668 206.355 170.529 206.355ZM251.679 203.112C251.554 203.112 251.43 203.068 251.331 202.977C251.12 202.785 251.106 202.459 251.298 202.25C252.019 201.462 252.727 200.645 253.403 199.818C253.582 199.598 253.908 199.564 254.128 199.744C254.349 199.923 254.383 200.248 254.202 200.468C253.515 201.31 252.794 202.143 252.059 202.944C251.957 203.055 251.819 203.112 251.679 203.112ZM165.205 200.678C165.056 200.678 164.906 200.614 164.806 200.488C164.118 199.647 163.446 198.776 162.807 197.897C162.641 197.667 162.691 197.345 162.922 197.179C163.154 197.012 163.476 197.063 163.643 197.293C164.271 198.156 164.93 199.011 165.605 199.838C165.784 200.058 165.751 200.383 165.531 200.562C165.436 200.64 165.32 200.678 165.205 200.678ZM256.532 197.028C256.432 197.028 256.329 196.998 256.24 196.937C256.005 196.775 255.947 196.455 256.108 196.222C256.715 195.343 257.307 194.436 257.862 193.526C258.01 193.283 258.328 193.206 258.571 193.355C258.815 193.502 258.892 193.819 258.743 194.062C258.177 194.99 257.576 195.914 256.956 196.808C256.858 196.95 256.696 197.028 256.532 197.028ZM160.704 194.335C160.529 194.335 160.361 194.248 160.263 194.089C159.697 193.163 159.149 192.209 158.638 191.254C158.504 191.003 158.599 190.692 158.85 190.557C159.102 190.424 159.414 190.518 159.549 190.769C160.052 191.707 160.589 192.644 161.146 193.554C161.294 193.797 161.217 194.113 160.974 194.262C160.888 194.31 160.795 194.335 160.704 194.335ZM260.515 190.339C260.436 190.339 260.357 190.322 260.283 190.284C260.028 190.155 259.926 189.846 260.055 189.594C260.538 188.64 260.999 187.66 261.425 186.681C261.539 186.421 261.844 186.302 262.104 186.415C262.365 186.528 262.484 186.83 262.371 187.091C261.937 188.087 261.468 189.085 260.976 190.055C260.886 190.235 260.703 190.339 260.515 190.339ZM157.112 187.444C156.914 187.444 156.723 187.328 156.638 187.135C156.204 186.142 155.793 185.122 155.417 184.106C155.318 183.84 155.455 183.545 155.723 183.446C155.99 183.347 156.286 183.483 156.385 183.75C156.755 184.748 157.158 185.748 157.584 186.724C157.697 186.984 157.578 187.287 157.316 187.402C157.25 187.43 157.18 187.444 157.112 187.444ZM263.545 183.168C263.49 183.168 263.433 183.159 263.378 183.14C263.109 183.047 262.964 182.755 263.057 182.487C263.403 181.478 263.724 180.446 264.012 179.421C264.089 179.148 264.374 178.988 264.648 179.063C264.921 179.14 265.082 179.424 265.006 179.697C264.714 180.742 264.386 181.793 264.034 182.82C263.96 183.033 263.759 183.168 263.545 183.168ZM154.497 180.129C154.272 180.129 154.064 179.98 154 179.754C153.706 178.709 153.438 177.642 153.205 176.581C153.144 176.303 153.32 176.029 153.599 175.967C153.877 175.906 154.152 176.082 154.214 176.36C154.444 177.402 154.706 178.45 154.994 179.476C155.071 179.749 154.911 180.033 154.637 180.11C154.59 180.122 154.543 180.129 154.497 180.129ZM265.557 175.658C265.524 175.658 265.491 175.655 265.458 175.649C265.178 175.594 264.995 175.324 265.05 175.045C265.255 174 265.431 172.933 265.576 171.877C265.614 171.596 265.875 171.398 266.156 171.436C266.438 171.473 266.636 171.734 266.599 172.015C266.452 173.091 266.271 174.177 266.064 175.241C266.015 175.489 265.799 175.658 265.557 175.658ZM152.911 172.518C152.658 172.518 152.436 172.332 152.401 172.074C152.253 171.001 152.135 169.907 152.049 168.823C152.027 168.539 152.238 168.291 152.522 168.269C152.807 168.246 153.056 168.458 153.078 168.742C153.163 169.805 153.279 170.879 153.424 171.935C153.463 172.216 153.265 172.476 152.983 172.514C152.958 172.517 152.935 172.518 152.911 172.518ZM266.522 167.946C266.512 167.946 266.503 167.946 266.492 167.944C266.207 167.929 265.99 167.685 266.005 167.401C266.065 166.339 266.095 165.26 266.095 164.191V164.08C266.095 163.796 266.325 163.565 266.61 163.565C266.61 163.565 266.61 163.565 266.611 163.565C266.896 163.565 267.127 163.794 267.127 164.078V164.191C267.127 165.278 267.096 166.377 267.036 167.46C267.02 167.734 266.792 167.946 266.522 167.946ZM152.379 164.764C152.095 164.764 151.863 164.535 151.863 164.251V164.194C151.863 163.126 151.893 162.045 151.951 160.982C151.967 160.698 152.211 160.48 152.494 160.497C152.779 160.513 152.996 160.756 152.98 161.039C152.922 162.082 152.894 163.143 152.894 164.193V164.248C152.895 164.532 152.666 164.762 152.379 164.764ZM266.424 160.061C266.158 160.061 265.932 159.857 265.911 159.587C265.825 158.523 265.707 157.449 265.562 156.396C265.522 156.115 265.721 155.854 266.002 155.815C266.284 155.776 266.545 155.974 266.584 156.254C266.732 157.328 266.853 158.421 266.94 159.504C266.964 159.787 266.751 160.036 266.468 160.058C266.451 160.061 266.438 160.061 266.424 160.061ZM152.897 157.008C152.873 157.008 152.851 157.006 152.828 157.003C152.546 156.965 152.348 156.706 152.386 156.424C152.532 155.347 152.71 154.262 152.917 153.198C152.971 152.918 153.242 152.736 153.522 152.79C153.802 152.843 153.984 153.113 153.931 153.392C153.728 154.437 153.551 155.504 153.408 156.562C153.372 156.821 153.152 157.008 152.897 157.008ZM265.269 152.376C265.032 152.376 264.819 152.212 264.766 151.972C264.536 150.93 264.272 149.884 263.982 148.858C263.905 148.585 264.064 148.301 264.339 148.222C264.615 148.145 264.898 148.304 264.976 148.578C265.271 149.623 265.54 150.69 265.774 151.749C265.836 152.027 265.659 152.302 265.382 152.363C265.343 152.371 265.305 152.376 265.269 152.376ZM154.467 149.394C154.422 149.394 154.374 149.388 154.329 149.375C154.055 149.299 153.893 149.016 153.97 148.741C154.263 147.696 154.588 146.645 154.939 145.617C155.03 145.349 155.325 145.205 155.594 145.297C155.863 145.39 156.007 145.682 155.915 145.95C155.57 146.959 155.249 147.991 154.963 149.018C154.9 149.245 154.692 149.394 154.467 149.394ZM263.071 144.918C262.862 144.918 262.665 144.789 262.587 144.582C262.217 143.584 261.811 142.584 261.385 141.61C261.27 141.349 261.389 141.047 261.65 140.932C261.912 140.819 262.215 140.937 262.33 141.197C262.764 142.19 263.177 143.209 263.554 144.224C263.653 144.491 263.516 144.786 263.249 144.885C263.191 144.908 263.129 144.918 263.071 144.918ZM157.069 142.065C157 142.065 156.931 142.051 156.865 142.023C156.604 141.91 156.484 141.607 156.597 141.346C157.03 140.35 157.499 139.352 157.99 138.381C158.117 138.126 158.429 138.024 158.682 138.153C158.937 138.28 159.039 138.591 158.91 138.843C158.429 139.797 157.969 140.777 157.543 141.756C157.458 141.949 157.269 142.065 157.069 142.065ZM259.873 137.839C259.689 137.839 259.511 137.74 259.418 137.568C258.914 136.629 258.375 135.693 257.818 134.784C257.67 134.542 257.745 134.226 257.989 134.076C258.232 133.927 258.549 134.004 258.699 134.248C259.267 135.173 259.814 136.126 260.327 137.081C260.463 137.332 260.367 137.643 260.116 137.778C260.038 137.82 259.954 137.839 259.873 137.839ZM160.657 135.156C160.565 135.156 160.473 135.132 160.389 135.081C160.145 134.933 160.068 134.616 160.216 134.373C160.783 133.446 161.382 132.521 162 131.625C162.162 131.392 162.483 131.332 162.718 131.494C162.952 131.655 163.012 131.975 162.85 132.209C162.243 133.088 161.654 133.996 161.097 134.907C161.001 135.067 160.831 135.156 160.657 135.156ZM255.733 131.258C255.574 131.258 255.417 131.185 255.315 131.046C254.687 130.185 254.026 129.33 253.35 128.505C253.169 128.285 253.202 127.96 253.422 127.781C253.642 127.601 253.968 127.634 254.147 127.853C254.836 128.694 255.508 129.565 256.149 130.442C256.315 130.673 256.265 130.995 256.034 131.161C255.944 131.227 255.839 131.258 255.733 131.258ZM165.153 128.801C165.038 128.801 164.924 128.763 164.828 128.687C164.606 128.508 164.573 128.183 164.752 127.963C165.438 127.121 166.159 126.287 166.892 125.484C167.084 125.274 167.409 125.26 167.62 125.451C167.831 125.642 167.845 125.967 167.653 126.178C166.933 126.965 166.225 127.784 165.551 128.613C165.452 128.735 165.303 128.801 165.153 128.801ZM250.735 125.296C250.599 125.296 250.464 125.242 250.362 125.137C249.622 124.367 248.85 123.609 248.068 122.882C247.859 122.689 247.848 122.363 248.043 122.156C248.236 121.949 248.563 121.936 248.771 122.131C249.567 122.87 250.352 123.643 251.106 124.426C251.303 124.632 251.296 124.957 251.09 125.154C250.991 125.249 250.862 125.296 250.735 125.296ZM170.47 123.115C170.331 123.115 170.194 123.06 170.093 122.951C169.898 122.744 169.909 122.418 170.117 122.225C170.912 121.483 171.738 120.755 172.573 120.06C172.792 119.877 173.117 119.906 173.3 120.124C173.482 120.342 173.454 120.667 173.235 120.849C172.416 121.531 171.604 122.248 170.824 122.976C170.723 123.068 170.597 123.115 170.47 123.115ZM244.97 120.061C244.858 120.061 244.745 120.025 244.649 119.95C243.81 119.286 242.944 118.639 242.069 118.024C241.836 117.861 241.781 117.539 241.944 117.307C242.108 117.075 242.431 117.02 242.663 117.183C243.554 117.809 244.437 118.468 245.291 119.143C245.514 119.32 245.552 119.644 245.374 119.866C245.272 119.994 245.123 120.061 244.97 120.061ZM176.508 118.2C176.346 118.2 176.187 118.125 176.086 117.984C175.921 117.751 175.976 117.431 176.209 117.266C177.096 116.639 178.014 116.028 178.936 115.454C179.176 115.303 179.496 115.376 179.647 115.617C179.798 115.857 179.725 116.176 179.483 116.327C178.578 116.891 177.679 117.491 176.805 118.108C176.716 118.169 176.61 118.2 176.508 118.2ZM238.546 115.652C238.456 115.652 238.367 115.628 238.283 115.58C237.363 115.035 236.414 114.511 235.464 114.022C235.211 113.891 235.111 113.581 235.242 113.328C235.373 113.075 235.684 112.976 235.937 113.107C236.905 113.606 237.871 114.139 238.809 114.693C239.054 114.837 239.135 115.153 238.99 115.398C238.894 115.562 238.722 115.652 238.546 115.652ZM183.155 114.15C182.97 114.15 182.789 114.05 182.697 113.872C182.565 113.62 182.664 113.309 182.916 113.179C183.881 112.678 184.872 112.198 185.863 111.754C186.123 111.638 186.428 111.753 186.546 112.011C186.662 112.27 186.547 112.575 186.288 112.692C185.315 113.129 184.342 113.599 183.394 114.092C183.317 114.131 183.236 114.15 183.155 114.15ZM231.576 112.157C231.51 112.157 231.442 112.145 231.376 112.117C230.388 111.704 229.377 111.313 228.367 110.957C228.098 110.863 227.958 110.568 228.052 110.301C228.146 110.033 228.442 109.893 228.71 109.987C229.737 110.35 230.769 110.747 231.774 111.167C232.037 111.277 232.161 111.578 232.05 111.84C231.97 112.038 231.779 112.157 231.576 112.157ZM190.29 111.045C190.078 111.045 189.88 110.913 189.804 110.703C189.708 110.435 189.848 110.141 190.117 110.045C191.142 109.68 192.191 109.341 193.236 109.035C193.509 108.955 193.796 109.11 193.876 109.383C193.956 109.656 193.799 109.942 193.527 110.022C192.501 110.322 191.47 110.656 190.465 111.014C190.407 111.034 190.349 111.045 190.29 111.045ZM224.194 109.648C224.15 109.648 224.106 109.642 224.062 109.631C223.03 109.358 221.974 109.11 220.928 108.897C220.649 108.84 220.468 108.567 220.527 108.29C220.583 108.012 220.857 107.831 221.136 107.889C222.202 108.107 223.275 108.36 224.328 108.638C224.603 108.71 224.767 108.992 224.694 109.267C224.632 109.496 224.422 109.648 224.194 109.648ZM197.794 108.941C197.554 108.941 197.34 108.774 197.289 108.531C197.23 108.253 197.41 107.98 197.688 107.922C198.753 107.701 199.839 107.508 200.917 107.348C201.198 107.306 201.461 107.5 201.504 107.781C201.546 108.062 201.351 108.324 201.069 108.366C200.012 108.523 198.945 108.713 197.899 108.931C197.863 108.938 197.828 108.941 197.794 108.941ZM216.543 108.173C216.523 108.173 216.501 108.172 216.48 108.17C215.421 108.04 214.342 107.938 213.274 107.869C212.989 107.85 212.773 107.605 212.792 107.321C212.811 107.037 213.055 106.824 213.341 106.841C214.428 106.913 215.527 107.015 216.606 107.149C216.889 107.183 217.091 107.441 217.054 107.721C217.023 107.982 216.799 108.173 216.543 108.173ZM205.514 107.88C205.245 107.88 205.018 107.673 204.999 107.401C204.981 107.117 205.195 106.873 205.479 106.852C206.563 106.778 207.666 106.733 208.755 106.719C209.041 106.714 209.274 106.943 209.277 107.227C209.28 107.511 209.052 107.745 208.768 107.748C207.696 107.762 206.614 107.806 205.55 107.878C205.538 107.88 205.525 107.88 205.514 107.88Z" fill="#039D55"/>
      <path d="M46.9209 85.9688H49.0402C49.3407 85.9688 49.5862 86.212 49.5862 86.5132C49.5862 86.8129 49.3423 87.0577 49.0402 87.0577H46.9209C46.6204 87.0577 46.375 86.8145 46.375 86.5132C46.375 86.3626 46.4364 86.2277 46.5355 86.1288C46.6346 86.0299 46.7699 85.9688 46.9209 85.9688Z" fill="#039D55"/>
      <path d="M54.8348 86.5012C54.838 86.655 54.7766 86.7947 54.6759 86.8951C54.5768 86.9939 54.4415 87.0536 54.2905 87.0536H52.1712C51.8707 87.0536 51.6252 86.8104 51.6252 86.5091C51.6252 86.2094 51.8691 85.9646 52.1712 85.9646H54.2779C54.5752 85.9677 54.8286 86.2031 54.8348 86.5012Z" fill="#039D55"/>
      <path d="M51.1505 82.8375V84.9511C51.1505 85.2508 50.9066 85.4955 50.6045 85.4955C50.304 85.4955 50.0586 85.2523 50.0586 84.9511V82.8375C50.0586 82.5378 50.3025 82.293 50.6045 82.293C50.7556 82.293 50.8909 82.3542 50.99 82.4515C51.0891 82.5503 51.1505 82.6868 51.1505 82.8375Z" fill="#039D55"/>
      <path d="M50.6045 87.5273C50.905 87.5273 51.1505 87.7706 51.1505 88.0718V90.1854C51.1505 90.4851 50.9066 90.7299 50.6045 90.7299C50.4535 90.7299 50.3182 90.6687 50.2191 90.5699C50.12 90.471 50.0586 90.3361 50.0586 90.1854V88.0703C50.0602 87.7706 50.304 87.5273 50.6045 87.5273Z" fill="#039D55"/>
      <path d="M67.4693 185.836C66.2012 185.836 65.1738 186.861 65.1738 188.125C65.1738 189.39 66.2012 190.415 67.4693 190.415C68.7374 190.415 69.7648 189.39 69.7648 188.125C69.7648 186.861 68.7374 185.836 67.4693 185.836ZM67.4693 189.396C66.7645 189.396 66.1933 188.827 66.1933 188.124C66.1933 187.421 66.7645 186.851 67.4693 186.851C68.1742 186.851 68.7453 187.421 68.7453 188.124C68.7437 188.827 68.1726 189.396 67.4693 189.396Z" fill="#039D55"/>
      <path d="M78.164 165.523H79.4557C79.6398 165.523 79.7877 165.673 79.7877 165.855C79.7877 166.038 79.6382 166.186 79.4557 166.186H78.164C77.9799 166.186 77.832 166.037 77.832 165.855C77.832 165.764 77.8698 165.68 77.9296 165.621C77.9894 165.561 78.0712 165.523 78.164 165.523Z" fill="#039D55"/>
      <path d="M82.9869 165.852C82.9885 165.946 82.9507 166.031 82.8894 166.092C82.8296 166.152 82.7462 166.19 82.6549 166.19H81.3632C81.1791 166.19 81.0312 166.04 81.0312 165.858C81.0312 165.675 81.1807 165.527 81.3632 165.527H82.6471C82.8296 165.526 82.9838 165.67 82.9869 165.852Z" fill="#039D55"/>
      <path d="M80.7421 163.616V164.904C80.7421 165.088 80.5926 165.236 80.4101 165.236C80.226 165.236 80.0781 165.087 80.0781 164.904V163.616C80.0781 163.433 80.2276 163.285 80.4101 163.285C80.5013 163.285 80.5847 163.323 80.6445 163.382C80.7043 163.442 80.7421 163.525 80.7421 163.616Z" fill="#039D55"/>
      <path d="M80.4101 166.477C80.5942 166.477 80.7421 166.626 80.7421 166.808V168.096C80.7421 168.279 80.5926 168.427 80.4101 168.427C80.3188 168.427 80.2355 168.389 80.1757 168.33C80.1159 168.27 80.0781 168.187 80.0781 168.096V166.808C80.0781 166.624 80.226 166.477 80.4101 166.477Z" fill="#039D55"/>
      <path d="M228.747 125.902C227.479 125.902 226.451 126.927 226.451 128.192C226.451 129.456 227.479 130.481 228.747 130.481C230.015 130.481 231.042 129.456 231.042 128.192C231.042 126.927 230.015 125.902 228.747 125.902ZM228.747 129.464C228.042 129.464 227.471 128.895 227.471 128.192C227.471 127.489 228.042 126.919 228.747 126.919C229.452 126.919 230.023 127.489 230.023 128.192C230.021 128.895 229.45 129.464 228.747 129.464Z" fill="#039D55"/>
      <path d="M238.151 143.848H239.745C239.971 143.848 240.155 144.031 240.155 144.257C240.155 144.483 239.971 144.667 239.745 144.667H238.151C237.924 144.667 237.74 144.483 237.74 144.257C237.74 144.144 237.786 144.042 237.86 143.968C237.934 143.895 238.038 143.848 238.151 143.848Z" fill="#039D55"/>
      <path d="M244.105 144.247C244.106 144.363 244.061 144.468 243.985 144.544C243.911 144.617 243.809 144.663 243.696 144.663H242.102C241.875 144.663 241.691 144.479 241.691 144.253C241.691 144.027 241.875 143.844 242.102 143.844H243.686C243.91 143.845 244.1 144.023 244.105 144.247Z" fill="#039D55"/>
      <path d="M241.333 141.492V143.081C241.333 143.307 241.149 143.491 240.922 143.491C240.696 143.491 240.512 143.307 240.512 143.081V141.492C240.512 141.266 240.696 141.082 240.922 141.082C241.036 141.082 241.138 141.128 241.212 141.201C241.287 141.277 241.333 141.379 241.333 141.492Z" fill="#039D55"/>
      <path d="M240.923 145.02C241.149 145.02 241.333 145.203 241.333 145.429V147.019C241.333 147.245 241.149 147.428 240.923 147.428C240.809 147.428 240.707 147.383 240.633 147.309C240.559 147.235 240.514 147.133 240.514 147.02V145.431C240.512 145.203 240.696 145.02 240.923 145.02Z" fill="#039D55"/>
      <path d="M222.127 235.594H223.721C223.948 235.594 224.132 235.777 224.132 236.003C224.132 236.229 223.948 236.413 223.721 236.413H222.127C221.901 236.413 221.717 236.229 221.717 236.003C221.717 235.89 221.762 235.788 221.836 235.715C221.912 235.639 222.014 235.594 222.127 235.594Z" fill="#039D55"/>
      <path d="M228.08 235.993C228.081 236.109 228.035 236.214 227.96 236.29C227.886 236.363 227.784 236.409 227.67 236.409H226.077C225.85 236.409 225.666 236.225 225.666 235.999C225.666 235.773 225.85 235.59 226.077 235.59H227.661C227.884 235.591 228.075 235.769 228.08 235.993Z" fill="#039D55"/>
      <path d="M225.31 233.238V234.827C225.31 235.053 225.125 235.237 224.899 235.237C224.672 235.237 224.488 235.053 224.488 234.827V233.238C224.488 233.012 224.672 232.828 224.899 232.828C225.012 232.828 225.114 232.874 225.188 232.947C225.262 233.023 225.31 233.125 225.31 233.238Z" fill="#039D55"/>
      <path d="M224.897 236.766C225.124 236.766 225.308 236.949 225.308 237.175V238.765C225.308 238.991 225.124 239.174 224.897 239.174C224.784 239.174 224.682 239.129 224.608 239.055C224.534 238.981 224.488 238.879 224.488 238.766V237.177C224.487 236.949 224.671 236.766 224.897 236.766Z" fill="#039D55"/>
      <path d="M198.069 35.1758C196.801 35.1758 195.773 36.2004 195.773 37.4651C195.773 38.7298 196.801 39.7545 198.069 39.7545C199.337 39.7545 200.364 38.7298 200.364 37.4651C200.364 36.2004 199.337 35.1758 198.069 35.1758ZM198.069 38.7377C197.364 38.7377 196.793 38.1681 196.793 37.4651C196.793 36.7622 197.364 36.1926 198.069 36.1926C198.774 36.1926 199.345 36.7622 199.345 37.4651C199.345 38.1681 198.774 38.7377 198.069 38.7377Z" fill="#039D55"/>
      <path d="M222.887 60.2539H224.481C224.708 60.2539 224.892 60.4375 224.892 60.6634C224.892 60.8894 224.708 61.073 224.481 61.073H222.887C222.661 61.073 222.477 60.8894 222.477 60.6634C222.477 60.5505 222.522 60.4485 222.596 60.3747C222.67 60.2994 222.774 60.2539 222.887 60.2539Z" fill="#039D55"/>
      <path d="M228.839 60.6533C228.841 60.7694 228.795 60.8745 228.72 60.9498C228.646 61.0236 228.543 61.0691 228.43 61.0691H226.836C226.61 61.0691 226.426 60.8855 226.426 60.6595C226.426 60.4336 226.61 60.25 226.836 60.25H228.421C228.646 60.2516 228.836 60.4289 228.839 60.6533Z" fill="#039D55"/>
      <path d="M226.069 57.8978V59.4873C226.069 59.7133 225.885 59.8969 225.659 59.8969C225.432 59.8969 225.248 59.7133 225.248 59.4873V57.8978C225.248 57.6719 225.432 57.4883 225.659 57.4883C225.772 57.4883 225.874 57.5338 225.948 57.6075C226.024 57.6829 226.069 57.7848 226.069 57.8978Z" fill="#039D55"/>
      <path d="M225.659 61.4258C225.886 61.4258 226.07 61.6094 226.07 61.8353V63.4248C226.07 63.6508 225.886 63.8344 225.659 63.8344C225.546 63.8344 225.444 63.7889 225.37 63.7151C225.296 63.6414 225.25 63.5394 225.25 63.4264V61.8353C225.248 61.6094 225.433 61.4258 225.659 61.4258Z" fill="#039D55"/>
      <path d="M252.137 133.475C251.061 133.475 249.977 133.381 248.915 133.197C248.704 133.161 248.564 132.96 248.6 132.75C248.637 132.539 248.836 132.4 249.047 132.436C250.065 132.613 251.104 132.703 252.134 132.703H252.188H252.189C252.402 132.703 252.575 132.875 252.576 133.087C252.576 133.3 252.405 133.473 252.191 133.475H252.137ZM256.658 132.911C256.484 132.911 256.327 132.795 256.283 132.621C256.231 132.414 256.355 132.205 256.563 132.152C257.58 131.895 258.582 131.546 259.54 131.116C259.735 131.028 259.963 131.116 260.051 131.311C260.139 131.505 260.051 131.733 259.856 131.821C258.857 132.268 257.812 132.632 256.752 132.9C256.722 132.907 256.689 132.911 256.658 132.911ZM244.672 131.902C244.62 131.902 244.566 131.891 244.516 131.869C243.512 131.429 242.542 130.898 241.632 130.291C241.454 130.172 241.407 129.933 241.525 129.756C241.645 129.579 241.884 129.531 242.062 129.649C242.933 130.23 243.863 130.74 244.826 131.162C245.021 131.248 245.111 131.476 245.024 131.67C244.961 131.816 244.82 131.902 244.672 131.902ZM263.553 129.53C263.439 129.53 263.325 129.48 263.248 129.382C263.116 129.215 263.146 128.973 263.314 128.841C264.142 128.193 264.916 127.47 265.616 126.691C265.759 126.533 266.003 126.519 266.162 126.662C266.321 126.804 266.335 127.048 266.192 127.206C265.462 128.019 264.655 128.772 263.793 129.448C263.72 129.503 263.637 129.53 263.553 129.53ZM238.44 127.421C238.335 127.421 238.229 127.379 238.154 127.294C237.419 126.484 236.752 125.606 236.168 124.68C236.055 124.499 236.108 124.261 236.289 124.148C236.47 124.035 236.709 124.088 236.823 124.269C237.383 125.157 238.023 125.999 238.726 126.776C238.869 126.935 238.857 127.178 238.7 127.321C238.626 127.388 238.533 127.421 238.44 127.421ZM268.473 123.647C268.412 123.647 268.351 123.633 268.294 123.603C268.105 123.504 268.033 123.271 268.132 123.082C268.62 122.16 269.03 121.184 269.353 120.183L269.361 120.159C269.425 119.957 269.644 119.844 269.847 119.91C270.05 119.974 270.163 120.192 270.097 120.394L270.089 120.42C269.752 121.463 269.324 122.481 268.816 123.443C268.747 123.572 268.613 123.647 268.473 123.647ZM234.577 120.798C234.415 120.798 234.264 120.694 234.211 120.533C233.868 119.494 233.615 118.421 233.457 117.341C233.427 117.131 233.574 116.935 233.784 116.903C233.995 116.872 234.192 117.019 234.223 117.23C234.374 118.265 234.617 119.295 234.946 120.289C235.013 120.492 234.901 120.71 234.699 120.777C234.659 120.791 234.618 120.798 234.577 120.798ZM270.574 116.249C270.566 116.249 270.556 116.249 270.547 116.247C270.333 116.233 270.172 116.05 270.187 115.836C270.213 115.444 270.226 115.045 270.226 114.651C270.226 114 270.19 113.341 270.119 112.693C270.095 112.481 270.25 112.292 270.462 112.268C270.674 112.244 270.865 112.398 270.888 112.61C270.962 113.286 271 113.974 271 114.653C271 115.064 270.986 115.48 270.959 115.89C270.945 116.094 270.775 116.249 270.574 116.249ZM233.747 113.181C233.734 113.181 233.72 113.181 233.707 113.18C233.495 113.158 233.341 112.968 233.361 112.756C233.473 111.673 233.681 110.589 233.981 109.536C234.039 109.331 234.253 109.211 234.459 109.269C234.665 109.327 234.785 109.541 234.727 109.746C234.439 110.757 234.239 111.797 234.132 112.834C234.11 113.034 233.942 113.181 233.747 113.181ZM269.468 108.668C269.31 108.668 269.162 108.573 269.104 108.416C268.741 107.434 268.288 106.476 267.759 105.571C267.652 105.387 267.713 105.15 267.899 105.044C268.083 104.937 268.321 104.998 268.428 105.183C268.978 106.126 269.45 107.124 269.829 108.149C269.903 108.348 269.801 108.571 269.601 108.645C269.559 108.661 269.513 108.668 269.468 108.668ZM236.092 105.886C236.028 105.886 235.962 105.871 235.901 105.836C235.715 105.731 235.65 105.494 235.756 105.31C236.299 104.361 236.93 103.456 237.631 102.616C237.768 102.453 238.012 102.431 238.176 102.568C238.339 102.704 238.361 102.947 238.226 103.111C237.554 103.916 236.948 104.785 236.428 105.693C236.358 105.816 236.228 105.886 236.092 105.886ZM265.372 102.185C265.272 102.185 265.171 102.146 265.095 102.067C264.362 101.316 263.56 100.624 262.709 100.013C262.536 99.8892 262.496 99.6475 262.62 99.4749C262.745 99.3023 262.987 99.2631 263.16 99.3871C264.047 100.024 264.886 100.746 265.651 101.53C265.8 101.683 265.795 101.927 265.643 102.077C265.567 102.149 265.47 102.185 265.372 102.185ZM241.215 100.175C241.096 100.175 240.978 100.12 240.902 100.016C240.776 99.8437 240.814 99.602 240.986 99.4765C241.868 98.8332 242.815 98.2604 243.797 97.7787C243.989 97.6846 244.22 97.763 244.315 97.9545C244.409 98.1459 244.33 98.3765 244.139 98.4707C243.196 98.9336 242.288 99.4812 241.44 100.099C241.374 100.15 241.294 100.175 241.215 100.175ZM258.984 97.9294C258.937 97.9294 258.889 97.9199 258.841 97.9011C258.459 97.7489 258.064 97.6077 257.671 97.4822C257.063 97.2876 256.442 97.1228 255.822 96.9926C255.613 96.9487 255.479 96.7447 255.523 96.536C255.567 96.3273 255.772 96.1939 255.981 96.2378C256.628 96.3728 257.276 96.5438 257.908 96.7478C258.319 96.8796 258.73 97.0271 259.128 97.1856C259.326 97.264 259.423 97.4884 259.343 97.6861C259.283 97.8368 259.139 97.9294 258.984 97.9294ZM248.22 97.0302C248.042 97.0302 247.881 96.9063 247.842 96.7258C247.797 96.5171 247.929 96.3116 248.138 96.2661C249.209 96.0339 250.306 95.8942 251.399 95.8518C251.612 95.844 251.793 96.0087 251.801 96.2221C251.809 96.4355 251.643 96.6144 251.429 96.6223C250.382 96.6631 249.329 96.7964 248.303 97.0193C248.275 97.0271 248.248 97.0302 248.22 97.0302Z" fill="#039D55"/>
      <path d="M60.713 154.975C60.186 154.975 59.651 154.958 59.124 154.926C58.91 154.914 58.7479 154.73 58.7621 154.517C58.7747 154.304 58.9588 154.143 59.1727 154.156C59.6841 154.187 60.2017 154.205 60.713 154.205C61.2322 154.205 61.7593 154.187 62.2769 154.154C62.4893 154.142 62.6734 154.302 62.6876 154.515C62.7017 154.729 62.5397 154.911 62.3257 154.925C61.7908 154.958 61.248 154.975 60.713 154.975ZM54.7847 154.269C54.7548 154.269 54.7234 154.266 54.6935 154.258C54.072 154.107 53.4458 153.933 52.8354 153.737C52.4326 153.608 52.0282 153.467 51.6333 153.32C51.4335 153.244 51.3328 153.022 51.4068 152.822C51.4823 152.623 51.7057 152.523 51.9055 152.598C52.2878 152.742 52.6812 152.879 53.0714 153.003C53.6645 153.193 54.2702 153.364 54.8744 153.508C55.0821 153.558 55.2095 153.767 55.1592 153.974C55.1167 154.15 54.9594 154.269 54.7847 154.269ZM66.6618 154.264C66.4872 154.264 66.3298 154.147 66.2858 153.969C66.2354 153.762 66.3629 153.553 66.5706 153.503C67.5728 153.26 68.5703 152.953 69.5363 152.587C69.7361 152.512 69.9595 152.612 70.035 152.811C70.1106 153.011 70.0099 153.233 69.81 153.309C68.8141 153.685 67.7852 154.004 66.7531 154.253C66.7216 154.26 66.6917 154.264 66.6618 154.264ZM47.7912 151.441C47.7236 151.441 47.6559 151.424 47.5946 151.388C46.6773 150.847 45.7868 150.243 44.9451 149.591C44.7767 149.461 44.7453 149.218 44.8774 149.05C45.008 148.882 45.2519 148.851 45.4202 148.981C46.2352 149.612 47.1006 150.199 47.9895 150.723C48.1736 150.831 48.2349 151.068 48.1248 151.252C48.0524 151.374 47.9234 151.441 47.7912 151.441ZM73.6474 151.421C73.5152 151.421 73.3862 151.354 73.3139 151.233C73.2053 151.049 73.2651 150.812 73.4492 150.704C74.3365 150.178 75.2003 149.591 76.0153 148.959C76.1836 148.829 76.4275 148.859 76.5581 149.027C76.6887 149.194 76.6588 149.438 76.4904 149.568C75.6503 150.219 74.7598 150.823 73.8441 151.366C73.7827 151.404 73.7151 151.421 73.6474 151.421ZM41.9463 146.679C41.8409 146.679 41.7355 146.637 41.66 146.552C40.9472 145.766 40.2754 144.925 39.6634 144.056C39.5407 143.881 39.5832 143.64 39.7578 143.517C39.9324 143.395 40.1747 143.437 40.2975 143.612C40.8906 144.456 41.542 145.27 42.2342 146.034C42.3774 146.193 42.3648 146.436 42.2075 146.579C42.132 146.646 42.0391 146.679 41.9463 146.679ZM79.4892 146.657C79.3964 146.657 79.3035 146.624 79.2296 146.557C79.0707 146.414 79.0597 146.169 79.2028 146.012C79.8967 145.248 80.548 144.434 81.1396 143.59C81.2623 143.415 81.5031 143.373 81.6777 143.494C81.8523 143.616 81.8948 143.856 81.7737 144.03C81.1632 144.901 80.4914 145.741 79.7771 146.529C79.7 146.615 79.5946 146.657 79.4892 146.657ZM37.7723 140.411C37.6259 140.411 37.4875 140.329 37.4214 140.188C36.9699 139.226 36.5749 138.226 36.2477 137.217C36.1816 137.015 36.2933 136.797 36.4963 136.731C36.6992 136.665 36.9179 136.776 36.984 136.979C37.3018 137.958 37.6857 138.928 38.1231 139.86C38.2144 140.053 38.1294 140.282 37.9359 140.373C37.8824 140.398 37.8273 140.411 37.7723 140.411ZM83.657 140.382C83.6019 140.382 83.5468 140.371 83.4949 140.346C83.3014 140.257 83.2164 140.028 83.3061 139.833C83.7388 138.903 84.1195 137.931 84.4373 136.949L84.4468 136.918C84.5113 136.715 84.73 136.602 84.9329 136.668C85.1359 136.733 85.2492 136.951 85.1831 137.153L85.1721 137.184C84.8448 138.198 84.4531 139.198 84.0062 140.158C83.9417 140.299 83.8017 140.382 83.657 140.382ZM35.6262 133.197C35.4359 133.197 35.2707 133.058 35.2439 132.865C35.096 131.813 35.0142 130.742 35 129.681C34.9969 129.467 35.1684 129.293 35.3824 129.29C35.5963 129.285 35.771 129.458 35.7741 129.671C35.7883 130.699 35.8669 131.738 36.0101 132.758C36.04 132.97 35.8921 133.164 35.6797 133.194C35.6624 133.196 35.6435 133.197 35.6262 133.197ZM85.7935 133.13C85.7762 133.13 85.7589 133.128 85.74 133.127C85.5276 133.098 85.3798 132.902 85.4096 132.692C85.5497 131.672 85.6268 130.632 85.6394 129.604C85.6409 129.392 85.814 129.223 86.0264 129.223C86.028 129.223 86.0295 129.223 86.0311 129.223C86.2451 129.224 86.4166 129.4 86.4134 129.613C86.4008 130.674 86.3222 131.746 86.1774 132.799C86.1507 132.99 85.9839 133.13 85.7935 133.13ZM35.7159 125.673C35.6955 125.673 35.6734 125.672 35.653 125.669C35.4421 125.634 35.299 125.436 35.3336 125.226C35.5051 124.181 35.7442 123.134 36.0463 122.113C36.1061 121.909 36.3216 121.791 36.5262 121.851C36.7307 121.911 36.8487 122.126 36.7873 122.33C36.4947 123.32 36.2619 124.336 36.0967 125.35C36.0668 125.538 35.9016 125.673 35.7159 125.673ZM85.6881 125.606C85.5025 125.606 85.3388 125.472 85.3074 125.283C85.139 124.269 84.903 123.254 84.6088 122.267C84.5475 122.063 84.6639 121.848 84.87 121.787C85.0745 121.725 85.2901 121.842 85.3514 122.047C85.6551 123.065 85.8974 124.112 86.072 125.157C86.1066 125.367 85.965 125.567 85.7542 125.601C85.7306 125.604 85.7086 125.606 85.6881 125.606ZM38.0208 118.509C37.9626 118.509 37.9044 118.496 37.8493 118.47C37.6574 118.375 37.5787 118.143 37.6731 117.953C38.1451 116.999 38.6832 116.067 39.2701 115.182C39.3881 115.005 39.6288 114.956 39.8066 115.074C39.9844 115.192 40.0331 115.43 39.9151 115.609C39.3456 116.467 38.8248 117.371 38.367 118.295C38.3009 118.429 38.164 118.509 38.0208 118.509ZM83.3596 118.451C83.218 118.451 83.0811 118.372 83.0135 118.237C82.5525 117.316 82.0286 116.414 81.4574 115.557C81.3394 115.38 81.3882 115.14 81.566 115.022C81.7438 114.904 81.9845 114.953 82.1025 115.13C82.6909 116.014 83.2306 116.944 83.7073 117.894C83.8033 118.085 83.7246 118.316 83.5342 118.411C83.476 118.437 83.4178 118.451 83.3596 118.451ZM42.3412 112.336C42.2452 112.336 42.1493 112.301 42.0753 112.229C41.9211 112.082 41.9148 111.838 42.0612 111.683C42.7943 110.914 43.5841 110.183 44.4086 109.51C44.5738 109.375 44.8176 109.398 44.9529 109.565C45.0883 109.729 45.0647 109.973 44.8979 110.108C44.0986 110.76 43.3324 111.47 42.6213 112.215C42.5457 112.295 42.4435 112.336 42.3412 112.336ZM79.0251 112.289C78.9228 112.289 78.8205 112.248 78.745 112.169C78.0323 111.423 77.2661 110.715 76.4668 110.064C76.3016 109.929 76.2764 109.686 76.4118 109.521C76.5471 109.356 76.7909 109.331 76.9561 109.466C77.7806 110.137 78.5704 110.867 79.3067 111.636C79.4546 111.79 79.4483 112.035 79.2941 112.182C79.217 112.254 79.121 112.289 79.0251 112.289ZM48.2994 107.715C48.1641 107.715 48.0335 107.644 47.9612 107.519C47.8558 107.333 47.9218 107.098 48.1091 106.993C49.0373 106.474 50.0065 106.006 50.9914 105.604C51.1896 105.524 51.4146 105.618 51.4964 105.816C51.5767 106.014 51.4823 106.238 51.284 106.32C50.329 106.709 49.3882 107.162 48.4882 107.668C48.4284 107.699 48.3624 107.715 48.2994 107.715ZM73.059 107.679C72.9945 107.679 72.93 107.663 72.8702 107.63C71.9702 107.129 71.0278 106.681 70.0696 106.293C69.8714 106.213 69.7754 105.989 69.8557 105.791C69.9359 105.593 70.1609 105.498 70.3591 105.578C71.3488 105.976 72.3195 106.439 73.2478 106.955C73.435 107.059 73.5011 107.294 73.3972 107.481C73.328 107.608 73.1959 107.679 73.059 107.679ZM55.3511 105.041C55.1733 105.041 55.0128 104.917 54.9735 104.737C54.9279 104.528 55.06 104.322 55.2693 104.277C56.3093 104.051 57.3744 103.889 58.4333 103.795C58.6457 103.776 58.8345 103.933 58.8534 104.145C58.8722 104.357 58.7149 104.545 58.5025 104.564C57.4751 104.655 56.443 104.812 55.4345 105.032C55.4062 105.038 55.3779 105.041 55.3511 105.041ZM65.9979 105.03C65.9711 105.03 65.9428 105.027 65.916 105.021C64.9044 104.804 63.8723 104.649 62.8449 104.559C62.6325 104.54 62.4752 104.354 62.4925 104.142C62.5114 103.93 62.6986 103.773 62.911 103.79C63.9698 103.883 65.035 104.041 66.0765 104.266C66.2858 104.311 66.4179 104.515 66.3739 104.724C66.3361 104.906 66.1756 105.03 65.9979 105.03Z" fill="#039D55"/>
      <path d="M212.386 130.666L209.574 148.06L209.035 151.397C209.035 153.982 203.498 188.032 200.63 188.032L155.28 156.779L104.949 191.608C102.083 191.608 99.0682 154.967 99.0682 152.383L98.8684 148.06L98.0645 130.718L106.156 123.745L152.046 84.1949C153.938 82.8361 156.622 82.8361 158.515 84.1949L204.362 123.745L212.386 130.666Z" fill="#039D55"/>
      <path d="M212.386 130.666L209.574 148.06L209.035 151.397C209.035 153.982 203.498 188.032 200.63 188.032L155.28 156.779L104.949 191.608C102.083 191.608 99.0682 154.967 99.0682 152.383L98.8684 148.06L98.0645 130.718L106.156 123.745L152.046 84.1949C153.938 82.8361 156.622 82.8361 158.515 84.1949L204.362 123.745L212.386 130.666Z" fill="#090909" fill-opacity="0.5"/>
      <path d="M190.619 130.558V183.751H119.572V115.199H175.064L190.619 130.558Z" fill="white"/>
      <path d="M190.619 130.559V132.352H173.265V115.133L175.064 115.2L190.619 130.559Z" fill="#039D55"/>
      <path d="M190.62 130.558H175.064V115.199L190.62 130.558Z" fill="white"/>
      <path d="M156.384 166.928L182.393 140.466C189.225 133.517 198.973 129.547 209.206 129.547C211.608 129.547 213.558 131.125 213.558 133.073V169.125V203.799C213.558 205.747 210.309 208.704 207.906 208.704H193.128L156.384 171.322C155.156 170.071 155.156 168.177 156.384 166.928Z" fill="#039D55"/>
      <path d="M156.384 166.928L182.393 140.466C189.225 133.517 198.973 129.547 209.206 129.547C211.608 129.547 213.558 131.125 213.558 133.073V169.125V203.799C213.558 205.747 210.309 208.704 207.906 208.704H193.128L156.384 171.322C155.156 170.071 155.156 168.177 156.384 166.928Z" fill="#090909" fill-opacity="0.8"/>
      <path d="M154.175 166.881L128.165 140.42C121.333 133.47 111.585 129.5 101.352 129.5C98.9494 129.5 97 131.079 97 133.026V169.078V204.176C97 206.123 99.7895 208.705 102.192 208.705L117.43 208.656L154.173 171.275C155.404 170.024 155.404 168.132 154.175 166.881Z" fill="#039D55"/>
      <path d="M154.175 166.881L128.165 140.42C121.333 133.47 111.585 129.5 101.352 129.5C98.9494 129.5 97 131.079 97 133.026V169.078V204.176C97 206.123 99.7895 208.705 102.192 208.705L117.43 208.656L154.173 171.275C155.404 170.024 155.404 168.132 154.175 166.881Z" fill="#090909" fill-opacity="0.8"/>
      <path d="M213.559 189.322V204.575C213.559 206.855 211.233 208.703 208.367 208.703H102.192C99.3254 208.703 97 206.855 97 204.575V189.322L152.045 154.467C152.94 153.9 154.013 153.6 155.097 153.569C156.301 153.535 157.517 153.836 158.516 154.467L213.559 189.322Z" fill="#2B7D57"/>
      <path d="M97 182.962L144.902 157.445L145.838 158.399L97 189.324V182.962Z" fill="#090909"/>
      <path d="M97 182.962L144.902 157.445L145.838 158.399L97 189.324V182.962Z" fill="#039D55" fill-opacity="0.6"/>
      <path d="M213.559 182.962L165.657 157.445L164.721 158.399L213.559 189.324V182.962Z" fill="#090909"/>
      <path d="M213.559 182.962L165.657 157.445L164.721 158.399L213.559 189.324V182.962Z" fill="#039D55" fill-opacity="0.6"/>
      <path d="M155.097 137.688C149.523 137.688 145.004 142.194 145.004 147.753H165.191C165.19 142.194 160.671 137.688 155.097 137.688Z" fill="#039D55" fill-opacity="0.2"/>
      <path d="M155.097 136.931C157.981 136.931 160.32 134.598 160.32 131.721C160.32 128.844 157.981 126.512 155.097 126.512C152.212 126.512 149.873 128.844 149.873 131.721C149.873 134.598 152.212 136.931 155.097 136.931Z" fill="#039D55" fill-opacity="0.2"/>
      <path d="M202.043 53.5288C202.043 54.4237 201.683 55.2392 201.084 55.831C200.501 56.4228 199.686 56.7909 198.792 56.7909H129.251C127.463 56.7909 126 55.3258 126 53.536C126 52.6411 126.36 51.8255 126.959 51.2337C127.542 50.642 128.357 50.2739 129.251 50.2739H132.538C133.835 47.2571 136.833 45.1425 140.322 45.1425C142.672 45.1425 144.791 46.1024 146.333 47.6469C148.38 44.1682 152.157 41.8299 156.489 41.8299C157.679 41.8299 158.825 42.0103 159.906 42.3351C162.169 38.077 166.638 35.1758 171.799 35.1758C177.99 35.1758 183.194 39.3617 184.766 45.0559C185.905 44.4858 187.195 44.161 188.557 44.161C192.421 44.161 195.671 46.7447 196.702 50.2739H198.792C200.58 50.2739 202.043 51.7389 202.043 53.5288Z" fill="#039D55" fill-opacity="0.3"/>
      </g>
      </g>
      <defs>
      <clipPath id="clip0_2950_15049">
      <rect width="317" height="243" fill="white"/>
      </clipPath>
      <clipPath id="clip1_2950_15049">
      <rect width="236" height="204" fill="white" transform="translate(35 35.1758)"/>
      </clipPath>
      </defs>
      </svg>
      
  );
};

export default SubscribeImage;
